# VEN Backend - Production Deployment Guide

## Quick Setup for cPanel

### 1. Gmail Configuration
Before deploying, you need to set up Gmail App Password:

1. **Enable 2-Factor Authentication** on your Gmail account
2. Go to **Google Account Settings** → **Security** → **App passwords**
3. Generate a new app password for "Mail"
4. Copy the 16-character password (it will look like: `abcd efgh ijkl mnop`)

### 2. Environment Variables
Create a `.env` file in your root directory with these values:

```bash
# Server Configuration
PORT=3000
NODE_ENV=production

# Gmail Configuration
GMAIL_USER=youremail@gmail.com
GMAIL_APP_PASSWORD=abcdefghijklmnop

# Email Settings
RECIPIENT_EMAIL=youremail@gmail.com

# CORS Settings (replace with your actual domains)
ALLOWED_ORIGINS=https://yourdomain.com,https://www.yourdomain.com
```

### 3. cPanel Deployment Steps

1. **Upload Files**: Upload all files to your cPanel directory
2. **Install Dependencies**: Run `npm install` in cPanel terminal
3. **Configure Node.js App**:
   - Go to "Node.js Selector" in cPanel
   - Create new application
   - Set startup file: `server.js`
   - Set Node.js version: 14+ (Latest LTS recommended)
4. **Start Application**: Click "Start" in Node.js Selector

### 4. Testing Your Deployment

Test these endpoints after deployment:
- `https://yourdomain.com/` - Health check
- `https://yourdomain.com/api/contact/health` - Contact service
- `https://yourdomain.com/api/enquiry/health` - Enquiry service

### 5. Frontend Integration

Use these API endpoints in your frontend:

**Contact Form:**
```javascript
POST https://yourdomain.com/api/contact
{
  "name": "John Doe",
  "email": "john@example.com", 
  "phone": "+1234567890",
  "enquiry": "Your message here"
}
```

**Enquiry Form:**
```javascript
POST https://yourdomain.com/api/enquiry
{
  "name": "Jane Smith",
  "email": "jane@example.com",
  "phone": "+1234567890", 
  "enquiry": "Your enquiry details",
  "category": "General Inquiry",
  "title": "Subject of enquiry"
}
```

### 6. Security Notes

- Keep your `.env` file secure and never commit it to version control
- Use HTTPS in production
- Update `ALLOWED_ORIGINS` to include only your actual domains
- Monitor your Gmail account for any suspicious activity

### 7. Troubleshooting

**Common Issues:**
- **Emails not sending**: Check Gmail credentials and app password
- **CORS errors**: Verify `ALLOWED_ORIGINS` includes your frontend domain
- **Port issues**: cPanel may assign a different port, check Node.js app settings

For more detailed documentation, see the main README.md file.
